function loadPage(page) {
    const contentDiv = document.getElementById('content');

    // Dynamically load the JS file containing page content
    fetch(`pages/${page}.js`)
        .then(response => response.text())
        .then(scriptContent => {
            // Evaluate the fetched script to define the variable
            eval(scriptContent);

            // Load content based on page selection
            if (page === 'home') contentDiv.innerHTML = homeContent;
            if (page === 'about') contentDiv.innerHTML = aboutContent;
            if (page === 'contact') contentDiv.innerHTML = contactContent;

            // Update URL without refreshing the page
            window.history.pushState({}, '', `?page=${page}`);
        })
        .catch(error => {
            contentDiv.innerHTML = `<h1>Error loading page</h1><p>${error}</p>`;
        });
}

// Load default page based on URL or fallback to home
window.onload = () => {
    const params = new URLSearchParams(window.location.search);
    const page = params.get('page') || 'home';
    loadPage(page);
};

// Handle back/forward button events
window.onpopstate = () => {
    const params = new URLSearchParams(window.location.search);
    const page = params.get('page') || 'home';
    loadPage(page);
};
