
var deviceMap = null;
var markers = {};      // Store markers per device SN
mapboxgl.accessToken = "pk.eyJ1IjoiaG9zZWFrb3NrZWkiLCJhIjoiY21paDdkeDRpMDA3bTNkc2FwZGd1dWxoZyJ9.Lp_Nxc6q9-ZnAN0Zr7cWZw";

loadDevices();
$(".crud_section").html("");

function loadDevices() {
    let url = serverURL + "telemetry/latest";

    controller.getAuthRequest(url, true, async function(data, status) {

        let items = data;

        if (!items || items.length === 0) {
            console.log("No telemetry");
            return;
        }

        // Filter devices with GPS
        let validDevices = items.filter(d => d.latitude && d.longitude);

        if (validDevices.length === 0) return;

        // Initialize Mapbox map ONCE
        if (!deviceMap) {
            deviceMap = new mapboxgl.Map({
                container: "crud_section",
                style: "mapbox://styles/mapbox/streets-v12",
                center: [validDevices[0].longitude, validDevices[0].latitude],
                zoom: 13
            });

            deviceMap.addControl(new mapboxgl.NavigationControl());
        }

        validDevices.forEach(async (device) => {

            let lat = device.latitude;
            let lng = device.longitude;

            // Reverse geocode using Mapbox
            let address = "Resolving...";
            try {
                let geoUrl = `https://api.mapbox.com/geocoding/v5/mapbox.places/${lng},${lat}.json?access_token=${mapboxgl.accessToken}`;

                let r = await fetch(geoUrl);
                let j = await r.json();

                address = j.features?.length ? j.features[0].place_name : "Not found";
            } catch (error) {
                address = "Not found";
            }

            // HTML popup
            let popupHtml = `
                <div style="font-size:13px">
                    <b>Device:</b> ${device.deviceName || "N/A"} <br>
                    <b>Serial No:</b> ${device.deviceSn} <br>
                    <b>Speed:</b> ${device.speedKmh} km/h<br>
                    <b>Direction:</b> ${device.direction}°<br>
                    <b>Mileage:</b> ${device.mileageKm} km<br>
                    <b>Timestamp:</b> ${device.timestamp}<br>
                    <b>Address:</b> ${address}
                </div>
            `;

            // ROTATABLE TRUCK ICON
            let el = document.createElement("div");
            el.className = "truck-icon";

            el.style.width = "40px";
            el.style.height = "40px";
            el.style.backgroundImage = "url('https://cdn-icons-png.flaticon.com/512/1329/1329628.png')";
            el.style.backgroundSize = "contain";
            el.style.transform = `rotate(${device.direction || 0}deg)`;

            // Update marker if exists
            if (markers[device.deviceSn]) {
                markers[device.deviceSn].setLngLat([lng, lat]);

                // Update rotation
                markers[device.deviceSn]
                    .getElement().style.transform = `rotate(${device.direction}deg)`;
            } else {
                // Create new marker
                markers[device.deviceSn] = new mapboxgl.Marker(el)
                    .setLngLat([lng, lat])
                    .setPopup(new mapboxgl.Popup().setHTML(popupHtml))
                    .addTo(deviceMap);
            }

        });
    });
}
