$(document).ready(function() {
    $('.ui.form').form('add prompt', 'pin', 'Enter NUIT');
    // $('.ui.dropdown')
    //     .dropdown();
    $('.ui.form').form({
        on: 'blur',
        inline: true,
        fields: {
            email: {
                identifier: 'email',
                rules: [{
                        type: 'empty',
                        prompt: 'Please enter Email'
                    }, {
                        type: 'email',
                        prompt: 'Please enter a valid company e-mail'
                    },
                    {
                        type: 'regExp[/^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,6}$/]',
                        prompt: 'Should be a Valid Email Address'
                    }
                ]
            },
            password: {
                identifier: 'password',
                rules: [{
                    type: 'empty',
                }, {
                    type: 'minLength[4]',
                }, {
                    type: 'maxLength[50]',
                },
             ]
            },
          

        },
        onSuccess: function(event, fields) {
            event.preventDefault(); // Prevent form submission

            $('#loginbtn').html("Logging in... Please Wait!");
            $("#loginbtn").attr("disabled", true);
    
            setTimeout(function () {
                $('#loginbtn').html("Log In");
                $("#loginbtn").attr("disabled", false);
                window.location.href = "otp.html";

            }, 1000);


            var formJson = $("#login").serializeObject();
            var formData = JSON.stringify(formJson);
            var url = serverURL + "auth/authenticate";
            var async_status = true;
    
            controller.request(url, formData, async_status, function (data, status) {
    
                if (!status) {
                    controller.showToastMsg("Login Failed! Wrong Username or password ", "#ff6666");
                } else {
                    if (data.message == "NOT ACTIVATED") {
                        document.getElementById("otp").style.display = "block"; //open otp field
                        document.getElementById("newPassword").style.display = "block"; //open new password field
                        document.getElementById("confirmpass").style.display = "block"; //open confirm password field
                        document.getElementById('login_form_submit').style.display = 'none'; //close new submit button
                        document.getElementById('activate_form_submit').style.display = 'block'; //open activate button
                    } else if (data.message == "ACCOUNT LOCKED") {
                        controller.showToastMsg("Sorry your account has been locked by Admin, Kindly Contact EAA Admin", "#ff6666");
                    } else {
                        var jsonObj = JSON.stringify(data); // stringify user data 
                        localStorage.setItem("userObj", jsonObj); // add the json obj to the local storage                          
                        controller.loadUserAccess();
                        var rolesArr = data.roles;
                        //call role select function so as to create it's html
                        var rolesHTML = controller.loadRoleSelect(rolesArr, "");
    
                        //loop through the roles if it's more than one and let the user select
                        if (rolesArr.length > 1) {
                            var rolesHTML = controller.loadRoleSelect(rolesArr, "");
                            $('#replace').html('<div class="form-group"><select class="form-control input-lg" id="selectRoleVal" onchange="newRole()" name="selectRoleVal" style="margin-top: 9px;width: 100%;">' +
                                rolesHTML + '</select></div>' +
                                '<input type="button" onclick="backToLogin()" value="Back" class="ui button backtologin" tabindex="5">' +
                                '<input type="button" onclick="selectRole()" value="Proceed" class="ui button selectrole" tabindex="5">');
                            $(".login").removeClass("loading");
                        } else {
                            localStorage.setItem("currentRole", data.roles[0].role_id); // set current role to the first default role
                            $(".login").removeClass("loading");
                            // window.location = serverUIURL +"dashboard.html";
                            window.location = "./#app/dashboard"; //redirect to user profile
                            
                        }
                    }
                }
    
            });

        }
    }, {
        on: 'blur',
        inline: 'true'
    });
    

}(jQuery));

function loginpage(){
    setTimeout(function() {
        window.location.href = "otp.html";
    }, 1000);
}