$(document).ready(function() {
    // $('.ui.form').form('add prompt', 'pin', 'Enter NUIT');
    $('.ui.dropdown')
        .dropdown();
    $('.ui.form').form({
        on: 'blur',
        inline: true,
        fields: {
            fullName: {
                identifier: 'fullName',
                rules: [{
                        type: 'empty',
                        prompt: 'Full Name Required' 
                    },
                   
                    // {
                    //     type: 'regExp[/^[a-zA-Z\-]+$/]',
                    //     prompt: 'Should be a string'
                    // }
                ]
            },
            

            // lastName: {
            //     identifier: 'lastName',
            //     rules: [{
            //             type: 'empty',
            //             prompt: 'Last Name Required',
            //         },
            //         {
            //             type: 'regExp[/^[a-zA-Z\-]+$/]',
            //             prompt: 'Should be a string'
            //         }
            //     ]
            // },

            phoneNo: {
                identifier: 'phoneNo',
                rules: [{
                    type: 'empty',
                    prompt: 'Please enter Telephone',
                },
                {
                    type: 'number',
                    prompt: 'Please enter a valid phone number',
                },
                {
                    type: 'exactLength[10]',
                    prompt: 'Phone number must be exactly 9 digits',
                }
                ],
            },
            email: {
                identifier: 'email',
                rules: [{
                        type: 'empty',
                        prompt: 'Please enter Email'
                    }, {
                        type: 'email',
                        prompt: 'Please enter a valid company e-mail'
                    },
                    {
                        type: 'regExp[/^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,6}$/]',
                        prompt: 'Should be a Valid Email Address'
                    }
                ]
            },
            password: {
                identifier: 'password',
                rules: [
                    {
                        type: 'empty',
                        prompt: 'Password cannot be empty'
                    },
                    {
                        type: 'minLength[6]',
                        prompt: 'Password must be at least 8 characters long'
                    },
                    {
                        type: 'maxLength[50]',
                        prompt: 'Password cannot be longer than 50 characters'
                    },
                    // {
                    //     type: 'passwordStrength',
                    //     prompt: 'Password must contain at least one uppercase letter, one lowercase letter, one number, and one special character'
                    // }
                ]
            
        }
          
           

        },
        onSuccess: function(event, fields) {
            event.preventDefault(); // Prevent form submission

            $('#registerbtn').html("Registering in... Please Wait!");
            $("#registerbtn").attr("disabled", true);
    
            var formJson = $("#register").serializeObject();
            formJson.dateOfBirth = "N/A";
            formJson.dateOfBirth = "N/A";
            // formJson.userRoleIds = [userRoleIds.userRoleIds]
            formJson.userRoleIds = []
            var grecaptcharesponse = grecaptcha.getResponse();
            formJson.recapcha = grecaptcharesponse;

            var formData = JSON.stringify(formJson);
            var url = serverURL + "user/createUser";
            var async_status = true;
    
            controller.loginrequest(url, formData, async_status, function (data, status) {

                if(data.statusCode == 200){
                    controller.showToastMsg("Successfully Registered... Redirecting...Please wait!", "#1a5589");

                    var jsdata = data.entity;
                    var jsonObj = JSON.stringify(jsdata); // stringify user data 
                    localStorage.setItem("userObj", jsonObj); 
                    setTimeout(function () {
                        $('#registerbtn').html("Register Now");
                        $("#registerbtn").attr("disabled", false);
                        window.location.href = "authentication.html";
                    }, 2000);
                }else{
                    controller.showToastMsg("Registration Failed", "#ff6666");
                    setTimeout(function () {
                        $('#registerbtn').html("Register Now");
                        $("#registerbtn").attr("disabled", false);
                    }, 1000);
                    if(data.statusCode == 200){
                        controller.showToastMsg(data.message, "#ff6666");

                    }else  if(data.statusCode == 400){
                        controller.showToastMsg(data.message, "#ff6666");

                    } else  if(data.statusCode == 403){
                        controller.showToastMsg(data.message, "#ff6666");

    
                    }else  if(data.statusCode == 500){
                        controller.showToastMsg(data.message, "#ff6666");

    
                    }else{
                        controller.showToastMsg(data.message, "#ff6666");

                    }
                }
            });

        }
    }, {
        on: 'blur',
        inline: 'true'
    });
    

}(jQuery));

function loginpage(){
    setTimeout(function() {
        window.location.href = "otp.html";
    }, 1000);
}


// var option_99 = "";
// var url99 = serverURL + "role/getActiveRole";
// controller.requestWithToken(url99, function (data, status) {
//     if (data.length > 0) {
//         for (var i = 0; i < data.length; i++) {
//             option_99 += "<option selected value=''>-Select Option-</option>";
//             option_99 += '<option value=' + data[i].id + '>' + data[i].name + '</option>';
//             $('#userRoleIds').html(option_99);
//         }
//     } else {
//         option_99 += "<option value=''>-Select Option-</option>";
//         $('#userRoleIds').html(option_99);
//     }

// });

$.fn.form.settings.rules.passwordStrength = function(value) {
    return /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[!@#$%^&*()_+{}|:"<>?~\-=[\]\\;',./]).{8,}$/.test(value);
};
