$(document).ready(function() {
    $('.ui.form').form('add prompt', 'pin', 'Enter NUIT');
    // $('.ui.dropdown')
    //     .dropdown();
    $('.ui.form').form({
        on: 'blur',
        inline: true,
        fields: {
            fname: {
                identifier: 'fname',
                rules: [{
                        type: 'empty',
                        prompt: 'Please enter your Full Name'
                    },
                    {
                        type: 'regExp[/^[a-zA-Z\-]+$/]',
                        prompt: 'Should be a string'
                    }
                ]
            },

            phone_No: {
                identifier: 'phone_No',
                rules: [{
                    type: 'empty',
                    prompt: 'Please enter Telephone',
                },
                {
                    type: 'number',
                    prompt: 'Please enter a valid phone number',
                },
                {
                    type: 'exactLength[9]',
                    prompt: 'Phone number must be exactly 9 digits',
                }
                ],
            },
            email: {
                identifier: 'email',
                rules: [{
                        type: 'empty',
                        prompt: 'Please enter Email'
                    }, {
                        type: 'email',
                        prompt: 'Please enter a valid company e-mail'
                    },
                    {
                        type: 'regExp[/^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,6}$/]',
                        prompt: 'Should be a Valid Email Address'
                    }
                ]
            },
            password: {
                identifier: 'password',
                rules: [
                    {
                        type: 'empty',
                        prompt: 'Password cannot be empty'
                    },
                    {
                        type: 'minLength[6]',
                        prompt: 'Password must be at least 8 characters long'
                    },
                    {
                        type: 'maxLength[50]',
                        prompt: 'Password cannot be longer than 50 characters'
                    },
                    // {
                    //     type: 'passwordStrength',
                    //     prompt: 'Password must contain at least one uppercase letter, one lowercase letter, one number, and one special character'
                    // }
                ]
            
        }
          
           

        },
        onSuccess: function(event, fields) {
            event.preventDefault(); // Prevent form submission

            $('#registerbtn').html("Registering in... Please Wait!");
            $("#registerbtn").attr("disabled", true);
    
            var formJson = $("#login").serializeObject();
            var formData = JSON.stringify(formJson);
            var url = serverURL + "user/createUser";
            var async_status = true;
    
            controller.loginrequest(url, formData, async_status, function (data, status) {
                console.log("datadatadata 1" , data)
                console.log("datadatadata 2" , status)
                if(data.statusCode == 200){
                    var jsdata = data.entity;
                    var jsonObj = JSON.stringify(jsdata); // stringify user data 
                    localStorage.setItem("userObj", jsonObj); 
                    setTimeout(function () {
                        $('#loginbtn').html("Log In");
                        $("#loginbtn").attr("disabled", false);
                        
                    }, 1000);
                    window.location.href = "login.html";

                  
                }else{
                    setTimeout(function () {
                        $('#loginbtn').html("Continue");
                        $("#loginbtn").attr("disabled", false);
                    }, 1000);
                    if(data == 200){
                        
                    }else  if(data == 400){
    
                    } else  if(data == 403){
    
                    }else  if(data == 500){
    
                    }else{
                       
                    }
                }
            });

        }
    }, {
        on: 'blur',
        inline: 'true'
    });
    

}(jQuery));

function loginpage(){
    setTimeout(function() {
        window.location.href = "otp.html";
    }, 1000);
}