$(document).ready(function() {
    $('.ui.form').form({
        on: 'blur',
        inline: true,
        fields: {
            email: {
                identifier: 'email',
                rules: [{
                        type: 'empty',
                        prompt: 'Please enter Email'
                    }, {
                        type: 'email',
                        prompt: 'Please enter a valid company e-mail'
                    },
                    {
                        type: 'regExp[/^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,6}$/]',
                        prompt: 'Should be a Valid Email Address'
                    }
                ]
            },
        },
        onSuccess: function(event, fields) {
            event.preventDefault(); // Prevent form submission

            $('#loginbtn').html("Verifying... Please Wait!");
            $("#loginbtn").attr("disabled", true);
    
           
        

            var formJson = $("#mainForm").serializeObject();
            var formData = JSON.stringify(formJson);
            var url = serverURL + "auth/validateEmail?email="+formJson.email;
            var async_status = true;
    
            window.location.href = "authentication.html";

            controller.loginrequest(url, formData, async_status, function (data, status) {
                console.log("datadatadata 1" , data)
                console.log("datadatadata 2" , status)



                // controller.showToastMsg("Successfully Verified", "#1a5589");

               
                if(data.statusCode == 200){

                    localStorage.setItem("email", formJson.email);

                    var jsdata = data.entity;
                    var jsonObj = JSON.stringify(jsdata); // stringify user data 
                    localStorage.setItem("userObj", jsonObj); 
                    setTimeout(function () {
                        $('#loginbtn').html("Log In");
                        $("#loginbtn").attr("disabled", false);
                    }, 1000);

                    if(data.entity.otpAllowedOnLogin == true){
                        controller.showToastMsg(data.message, "#ff6666");
                         window.location.href = "otp.html";
                    }else{
                         window.location.href = "authentication.html";
                    }
                }else{
                    controller.showToastMsg(data.message, "#ff6666");

                    setTimeout(function () {
                        $('#loginbtn').html("Continue");
                        $("#loginbtn").attr("disabled", false);
                    }, 1000);
                    if(data == 200){
                        
                    }else  if(data == 400){
    
                    } else  if(data == 403){
    
                    }else  if(data == 500){
    
                    }else{
                       
                    }
                }
            });


        }
    }, {
        on: 'blur',
        inline: 'true'
    });
    

}(jQuery));